unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTrading, eBayTradingAPI, EA4DAPI, xWSDLIntf,
  eBayTradingIntf, eBayMerchandising, eBayMerchandisingIntf,
  eBayMerchandisingAPI, eBayProductMeta, eBayProductMetaIntf,
  eBayProductMetaAPI, eBayBulkData, eBayBulkDataIntf, eBayBulkDataAPI,
  eBayFileTransfer, eBayFileTransferIntf, eBayFileTransferAPI,
  ExtCtrls, eBayMerchantData, eBayMerchantDataIntf, eBayMerchantDataAPI;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    eBayBulkData1: TeBayBulkData;
    eBayFileTransfer1: TeBayFileTransfer;
    eBayBulkData2: TeBayBulkData;
    eBaySession1: TeBaySession;
    Timer1: TTimer;
    eBayMerchantData1: TeBayMerchantData;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    JobId, FileRefId : string;
  end;

var
  Form1: TForm1;

implementation
uses DateUtils;

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  if not eBaySession1.loadFromINI('..\demosession.ini','SANDBOX') then
  begin
    showMessage('Invalid Session Parameters..');
    exit;
  end;
  eBayBulkData1.Session := eBaySession1;
  eBayBulkData2.Session := eBaySession1;
  eBayFileTransfer1.Session := eBaySession1;
  Button1.Enabled := True;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
var
  i, j, k : integer;
  Status : string;
  Res : TeBayMD_BulkDataExchangeResponses;
begin
  eBayBulkData1.getJobStatus.Request.jobId.Value :=  JobId;
  eBayBulkData1.Call;
  if eBayBulkData1.getJobStatus.Response.ack.Value<>'Success'then
  begin
    Memo1.Lines.Add ('Failed...' + eBayBulkData1.createUploadJob.Response.errorMessage.error[0].message.Value);
    exit;
  end;
  for i:=0 to eBayBulkData1.getJobStatus.Response.jobProfile.Count-1 do
  begin
    if eBayBulkData1.getJobStatus.Response.jobProfile.Items[i].jobId.Value = JobId then
    begin
      Status := eBayBulkData1.getJobStatus.Response.jobProfile.Items[i].jobStatus.Value;
      Memo1.Lines.Add(Status);
      if Status = 'Completed' then
      begin
        Timer1.Enabled := False;
        Memo1.Lines.Add('Download Response File');
        eBayFileTransfer1.downloadFile.Request.taskReferenceId.Value := JobId;
        eBayFileTransfer1.downloadFile.Request.fileReferenceId.Value := eBayBulkData1.getJobStatus.Response.jobProfile.Items[i].fileReferenceId.Value;
        eBayFileTransfer1.Call;
        if eBayFileTransfer1.downloadFile.Response.ack.Value<>'Success'then
        begin
          Memo1.Lines.Add ('Failed...' + eBayFileTransfer1.downloadFile.Response.errorMessage.error[0].message.Value);
          exit;
        end;
        Memo1.Text := eBayFileTransfer1.downloadFile.Response.fileAttachment.Data.W3CStringValue;
        Res := TeBayMD_BulkDataExchangeResponses.Create(Self);
        Res.FromUnicodeString(eBayFileTransfer1.downloadFile.Response.fileAttachment.Data.W3CStringValue);
        for j:=0 to Res.AddFixedPriceItemResponse.Count-1 do
        begin
          Memo1.Lines.Add('Item '+inttostr(j+1)+' : '+Res.AddFixedPriceItemResponse.Items[j].Ack.Value);
          for k:=0 to Res.AddFixedPriceItemResponse.Items[j].Errors.Count-1 do
            Memo1.Lines.Add('  '+Res.AddFixedPriceItemResponse.Items[j].Errors.Items[k].LongMessage.Value);
        end;
      end;
    end;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  UUID, JobStatus : string;
  i : integer;
  Req : TeBayMD_BulkDataExchangeRequests;
begin
  Timer1.Enabled := False;
  Memo1.Clear;

  Memo1.Lines.Add('Create AddFixedPriceItem file');
  Req := TeBayMD_BulkDataExchangeRequests.Create(Self);
  Req.Header.SiteID.Value:=0;
  Req.Header.Version.Value := TCustomeBayMerchantData.GetAPIVersion;

  // 1st Item
  Req.AddFixedPriceItemRequest.Xmlns := 'urn:ebay:apis:eBLBaseComponents';  // To be compatible with eBay XML parser
  Req.AddFixedPriceItemRequest.New;
  Req.AddFixedPriceItemRequest.Last.ErrorLanguage.Value := 'en_US';
  Req.AddFixedPriceItemRequest.Last.WarningLevel.set_High;
  Req.AddFixedPriceItemRequest.Last.Version.Value := TCustomeBayMerchantData.GetAPIVersion;
  Req.AddFixedPriceItemRequest.Last.MessageID.Value := 'Request 1';
  Req.AddFixedPriceItemRequest.Last.Item.SKU.Value := '49203489082034';
  Req.AddFixedPriceItemRequest.Last.Item.Country.set_US;
  Req.AddFixedPriceItemRequest.Last.Item.Currency.set_USD;
  Req.AddFixedPriceItemRequest.Last.Item.Description.Value := 'An interesting item description 1';
  Req.AddFixedPriceItemRequest.Last.Item.DispatchTimeMax.Value := 3;
  Req.AddFixedPriceItemRequest.Last.Item.InventoryTrackingMethod.set_SKU;
  Req.AddFixedPriceItemRequest.Last.Item.ListingDuration.Value := 'Days_7';
  Req.AddFixedPriceItemRequest.Last.Item.ListingType.set_FixedPriceItem;
  Req.AddFixedPriceItemRequest.Last.Item.PostalCode.Value := '95125';
  Req.AddFixedPriceItemRequest.Last.Item.PaymentMethods.New.set_PayPal;
  Req.AddFixedPriceItemRequest.Last.Item.PayPalEmailAddress.Value := 'example@example.com';
  Req.AddFixedPriceItemRequest.Last.Item.PrimaryCategory.CategoryID.Value := '1463';
  Req.AddFixedPriceItemRequest.Last.Item.Quantity.Value := 10;
  Req.AddFixedPriceItemRequest.Last.Item.StartPrice.Value := 5.0;
  Req.AddFixedPriceItemRequest.Last.Item.ShippingDetails.ShippingType.set_Flat;
  Req.AddFixedPriceItemRequest.Last.Item.ShippingDetails.ShippingServiceOptions.New.ShippingServicePriority.Value := 1;
  Req.AddFixedPriceItemRequest.Last.Item.ShippingDetails.ShippingServiceOptions.Last.ShippingService.Value := 'USPSMedia';
  Req.AddFixedPriceItemRequest.Last.Item.ShippingDetails.ShippingServiceOptions.Last.ShippingServiceCost.Value := 2.50;
  Req.AddFixedPriceItemRequest.Last.Item.Title.Value := 'Testing LMS with the EA4D Sample Code';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.ReturnsAcceptedOption.Value := 'ReturnsAccepted';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.RefundOption.Value := 'MoneyBack';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.ReturnsWithinOption.Value := 'Days_30';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.Description.Value := 'Description of return policy details';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.ShippingCostPaidByOption.Value := 'Buyer';

  // 2nd Item
  Req.AddFixedPriceItemRequest.Xmlns := 'urn:ebay:apis:eBLBaseComponents'; // To be compatible with eBay XML parser
  Req.AddFixedPriceItemRequest.New;
  Req.AddFixedPriceItemRequest.Last.ErrorLanguage.Value := 'en_US';
  Req.AddFixedPriceItemRequest.Last.WarningLevel.set_High;
  Req.AddFixedPriceItemRequest.Last.Version.Value := TCustomeBayMerchantData.GetAPIVersion;
  Req.AddFixedPriceItemRequest.Last.MessageID.Value := 'Request 2';
  Req.AddFixedPriceItemRequest.Last.Item.SKU.Value := '49203999082034';
  Req.AddFixedPriceItemRequest.Last.Item.Country.set_US;
  Req.AddFixedPriceItemRequest.Last.Item.Currency.set_USD;
  Req.AddFixedPriceItemRequest.Last.Item.Description.Value := 'An interesting item description 2';
  Req.AddFixedPriceItemRequest.Last.Item.DispatchTimeMax.Value := 3;
  Req.AddFixedPriceItemRequest.Last.Item.InventoryTrackingMethod.set_SKU;
  Req.AddFixedPriceItemRequest.Last.Item.ListingDuration.Value := 'Days_7';
  Req.AddFixedPriceItemRequest.Last.Item.ListingType.set_FixedPriceItem;
  Req.AddFixedPriceItemRequest.Last.Item.PostalCode.Value := '95125';
  Req.AddFixedPriceItemRequest.Last.Item.PaymentMethods.New.set_PayPal;
  Req.AddFixedPriceItemRequest.Last.Item.PayPalEmailAddress.Value := 'example@example.com';
  Req.AddFixedPriceItemRequest.Last.Item.PrimaryCategory.CategoryID.Value := '1463';
  Req.AddFixedPriceItemRequest.Last.Item.Quantity.Value := 10;
  Req.AddFixedPriceItemRequest.Last.Item.StartPrice.Value := 5.0;
  Req.AddFixedPriceItemRequest.Last.Item.ShippingDetails.ShippingType.set_Flat;
  Req.AddFixedPriceItemRequest.Last.Item.ShippingDetails.ShippingServiceOptions.New.ShippingServicePriority.Value := 1;
  Req.AddFixedPriceItemRequest.Last.Item.ShippingDetails.ShippingServiceOptions.Last.ShippingService.Value := 'USPSMedia';
  Req.AddFixedPriceItemRequest.Last.Item.ShippingDetails.ShippingServiceOptions.Last.ShippingServiceCost.Value := 2.50;
  Req.AddFixedPriceItemRequest.Last.Item.Title.Value := 'Testing LMS with the EA4D Sample Code';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.ReturnsAcceptedOption.Value := 'ReturnsAccepted';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.RefundOption.Value := 'MoneyBack';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.ReturnsWithinOption.Value := 'Days_30';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.Description.Value := 'Description of return policy details';
  Req.AddFixedPriceItemRequest.Last.Item.ReturnPolicy.ShippingCostPaidByOption.Value := 'Buyer';

  Req.SaveToFile('EA4DAddFixedPriceItem.xml', 'BulkDataExchangeRequests' );

  Memo1.Lines.Add('Checking for pending Jobs...');
  eBayBulkData1.getJobs.Request;
  if not eBayBulkData1.Call then
  begin
    ShowMessage(eBayBulkData1.Error.EStr + ' ' + eBayBulkData1.Error.ECode);
    Exit;
  end;
  if eBayBulkData1.getJobs.Response.ack.Value<>'Success' then
  begin
    Memo1.Lines.Add ('Failed : ' + eBayBulkData1.Error.EStr);
    exit;
  end;

  for i:=0 to eBayBulkData1.getJobs.Response.jobProfile.Count-1 do
  begin
    JobStatus := eBayBulkData1.getJobs.Response.jobProfile[i].jobStatus.Value;
    if (JobStatus='Created') or (JobStatus='InProcess') or (JobStatus='Scheduled') then
    begin
      eBayBulkData2.abortJob.Request.jobId.Value := eBayBulkData1.getJobs.Response.jobProfile[i].jobId.Value;
      Memo1.Lines.Add('Killing Jobs : ' + eBayBulkData2.abortJob.Request.jobId.Value);
      eBayBulkData2.Call;
      if not eBayBulkData2.Call then
      begin
        ShowMessage(eBayBulkData2.Error.EStr + ' ' + eBayBulkData2.Error.ECode);
        Exit;
      end;
    end;
  end;

  UUID := TeBay.getUUID(True);
  Memo1.Lines.Add('UUID : ' + UUID);

  eBayBulkData1.createUploadJob.Request.UUID.Value := UUID;
  eBayBulkData1.createUploadJob.Request.uploadJobType.Value := 'AddFixedPriceItem';
  Memo1.Lines.Add('createUploadJob : ' + eBayBulkData1.createUploadJob.Request.UUID.Value);
  if not eBayBulkData2.Call then
  begin
    ShowMessage(eBayBulkData2.Error.EStr + ' ' + eBayBulkData2.Error.ECode);
    Exit;
  end;
  if eBayBulkData1.createUploadJob.Response.ack.Value<>'Success' then
  begin
    Memo1.Lines.Add ('Failed...' + eBayBulkData1.createUploadJob.Response.errorMessage.error[0].message.Value);
    exit;
  end;
  JobId := eBayBulkData1.createUploadJob.Response.jobId.Value;
  FileRefId := eBayBulkData1.createUploadJob.Response.fileReferenceId.Value;
  Memo1.Lines.Add ('JobID : ' + JobId);
  Memo1.Lines.Add ('RefID : ' + FileRefId);

  eBayFileTransfer1.uploadFile.Request.fileReferenceId.Value := FileRefId;
  eBayFileTransfer1.uploadFile.Request.taskReferenceId.Value := JobId;

  // There are 3 ways to upload a file :
  // 1 - On the fly loading and compression :
   eBayFileTransfer1.uploadFile.Request.fileAttachment.Data.FileName := 'EA4DAddFixedPriceItem.xml';
  // 2 - Direct loading and Auto-Commpression :
  // eBayFileTransfer1.uploadFile.Request.fileAttachment.Data.LoadBinaryFromFile('EA4DAddFixedPriceItem.xml');
  // 3 - Using an already compressed file :
  // eBayFileTransfer1.uploadFile.Request.fileFormat.Value := 'gzip';
  // eBayFileTransfer1.uploadFile.Request.fileAttachment.Data.LoadBinaryFromFile('AddFixedPriceItemExample.gz');

  eBayFileTransfer1.Call;
  if not eBayFileTransfer1.Call then
  begin
    ShowMessage(eBayFileTransfer1.Error.EStr + ' ' + eBayFileTransfer1.Error.ECode);
    Exit;
  end;
  if eBayFileTransfer1.uploadFile.Response.ack.Value<>'Success'  then
  begin
    Memo1.Lines.Add ('Failed...' + eBayFileTransfer1.uploadFile.Response.errorMessage.error[0].message.Value);
    exit;
  end;
  Memo1.Lines.Add ('File Uploaded...');

  Memo1.Lines.Add('Start Upload Job');
  eBayBulkData1.startUploadJob.Request.jobId.Value := JobId;
  if not eBayBulkData1.Call then
  begin
    ShowMessage(eBayBulkData1.Error.EStr + ' ' + eBayBulkData1.Error.ECode);
    Exit;
  end;
  if eBayBulkData1.startUploadJob.Response.ack.Value<>'Success'  then
  begin
    Memo1.Lines.Add ('Failed...' + eBayBulkData1.startUploadJob.Response.errorMessage.error[0].message.Value);
    exit;
  end;

  Memo1.Lines.Add ('Checking Job Status : ');
  Timer1.Enabled := True;
end;

end.
