unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  eBay, eBayTradingIntf, eBayTrading, StdCtrls, eBayTradingAPI, EA4DAPI,
  xWSDLIntf;

type
  TForm1 = class(TForm)
    eBayTrading1: TeBayTrading;
    Button1: TButton;
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    procedure Button1ClickStep2(Sender: TObject);
  public
    { Public declarations }
    SessionID : string;
  end;

var
  Form1: TForm1;

implementation
uses shellapi;
{$R *.DFM}

// READ FIRST :
// You will need to create a RUNAME for your application
// Got to your developper account, Application Setting
// Create a RUNAME with application type = client/desktop
// (You don't need to enter any URL)

const
 RUNAME = 'EA4D-EA4Dec272-8fab--dwtiph';

procedure TForm1.FormShow(Sender: TObject);
begin
  // load session data
  eBayTrading1.Session.loadFromINI('..\..\demosession.ini','SANDBOX');
  // Check if the session parameters seems valid for an eBay Trading call :
  if not(eBayTrading1.isSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    exit;
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  URL : string;
begin
  // Make sure that token is empty before calling GetSessionID.
  eBayTrading1.Session.Token := '';
  eBayTrading1.GetSessionID.Request.RuName.Value := RUNAME;
  if not(eBayTrading1.Call) then exit;
  SessionID := eBayTrading1.GetSessionID.Response.SessionID.Value;
  URL := 'https://signin.sandbox.ebay.com/ws/eBayISAPI.dll?SignIn&runame='+RUNAME+'&SessID='+SessionID;
  ShellExecute(self.WindowHandle,'open',PChar(URL), nil,nil, SW_SHOWNORMAL);
  Button1.OnClick :=  Button1ClickStep2;
  Button1.Caption := 'Continue...';
end;

procedure TForm1.Button1ClickStep2(Sender: TObject);
var
  Msg : string;
begin
  eBayTrading1.FetchToken.Request.SessionID.Value := SessionID;
  if (eBayTrading1.Call) then
  begin
    eBayTrading1.Session.Token := eBayTrading1.FetchToken.Response.eBayAuthToken.Value;
    Msg := 'Token Expiration : ' + DateTimeToStr(eBayTrading1.FetchToken.Response.HardExpirationTime.AsLocalDateTime);
    eBayTrading1.GetUser.Request;
    if (eBayTrading1.Call) then
    begin
        Msg := 'User : '+eBayTrading1.GetUser.Response.User.UserID.Value+ ' - ' + Msg;
        showmessage(Msg);
    end;
  end;
end;

end.
