unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls,
  eBay, xWSDLIntf, eBayFindingIntf, eBayFindingAPI, eBayFinding;
type
  TForm1 = class(TForm)
    Button1: TButton;
    eBayFinding1: TeBayFinding;
    Edit1: TEdit;
    Memo1: TMemo;
    Button2: TButton;
    procedure Button1Click(Sender: TObject);
    procedure eBayFinding1Success(Sender: TeBayFinding);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  if eBayFinding1.Busy then exit;
  eBayFinding1.Session.loadFromINI('..\..\demosession.ini','SANDBOX');
  // Please check ebay Finding API for GlobalId values (Default EBAY-US)
  // ex Germany : eBayFinding1.Session.FindingGlobalID := 'EBAY-DE';
  if not(eBayFinding1.isSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    exit;
  end;
  Memo1.Clear;
  eBayFinding1.FindItemsByKeywords.Request.keywords.Value := Edit1.Text;
  eBayFinding1.FindItemsByKeywords.Request.paginationInput.entriesPerPage.Value := 5;
  eBayFinding1.FindItemsByKeywords.Request.paginationInput.pageNumber.Value:=1;
  eBayFinding1.Start;
end;

procedure TForm1.eBayFinding1Success(Sender: TeBayFinding);
var
  Res : TeBayF_FindItemsByKeywordsResponse;
  Cnt,i : integer;
  Item: TeBayF_SearchItem;
begin
  Res := eBayFinding1.FindItemsByKeywords.Response;
  Cnt := Res.searchResult.item.Count;
  Button2.Enabled := (Cnt>0);
  for i:=0 to Cnt-1 do
  begin
    Item := Res.searchResult.item.Items[i];
    Memo1.lines.Insert(0, Item.itemId.Value+' - '+Item.title.Value);
  end;
  if (Cnt>0) then
  begin
    Cnt := eBayFinding1.FindItemsByKeywords.Request.paginationInput.pageNumber.Value;
    eBayFinding1.FindItemsByKeywords.Request.paginationInput.pageNumber.Value := Cnt+1;
  end
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if eBayFinding1.Busy then exit;
  eBayFinding1.Start;
end;

end.
