unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTradingIntf, eBayTrading, eBayTradingAPI,
  EA4DAPI, xWSDLIntf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    eBayTrading1: TeBayTrading;
    procedure Button1Click(Sender: TObject);
    procedure eBayTrading1Error(Sender: TeBayTrading);
    procedure eBayTrading1Success(Sender: TeBayTrading);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses ShellAPI;

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  eBayTrading1.Session.loadFromINI('..\..\demosession.ini','SANDBOX');

  if not(eBayTrading1.isSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    exit;
  end;

  eBayTrading1.AddItem.Request.Item.BuyItNowPrice.Value := random(999);
  eBayTrading1.AddItem.Request.Item.BuyItNowPrice.currencyID.set_USD;
  eBayTrading1.AddItem.Request.Item.Currency.set_USD;
  eBayTrading1.AddItem.Request.Item.Country.set_US;
  eBayTrading1.AddItem.Request.Item.Description.Value :=
    '<b><a href="http://www.ea4d.com">www.ea4d.com '+inttostr(random(999999))+'</a> </b>';
  eBayTrading1.AddItem.Request.Item.ListingDuration.Value := 'Days_7';
  eBayTrading1.AddItem.Request.Item.Quantity.Value := 1;
  eBayTrading1.AddItem.Request.Item.ListingType.Value := 'Chinese'; //Auction
  eBayTrading1.AddItem.Request.Item.Location.Value := 'San Jose';
  eBayTrading1.AddItem.Request.Item.PayPalEmailAddress.Value := 'support@ea4d.com';
  eBayTrading1.AddItem.Request.Item.PrimaryCategory.CategoryID.Value := '123422';

  eBayTrading1.AddItem.Request.Item.ItemSpecifics.NameValueList.New._Name.Value :='Brand';
  eBayTrading1.AddItem.Request.Item.ItemSpecifics.NameValueList.Last.Value.New.Value :='EA4D';
  eBayTrading1.AddItem.Request.Item.ItemSpecifics.NameValueList.New._Name.Value :='Type';
  eBayTrading1.AddItem.Request.Item.ItemSpecifics.NameValueList.Last.Value.New.Value :='OTG Adapter';

  eBayTrading1.AddItem.Request.Item.StartPrice.Value := 0.02;
  eBayTrading1.AddItem.Request.Item.Title.Value := 'Title : ea4d.com TEST '+inttostr(random(999999));
  eBayTrading1.AddItem.Request.Item.ShipToLocations.New.Value:='US';
  eBayTrading1.AddItem.Request.Item.ShippingDetails.ShippingType.Value:='Flat';
  eBayTrading1.AddItem.Request.Item.ConditionID.Value:=1000;
  // Domestic shipping
  eBayTrading1.AddItem.Request.Item.ShippingDetails.ShippingServiceOptions.New.FreeShipping.Value := True;
  eBayTrading1.AddItem.Request.Item.ShippingDetails.ShippingServiceOptions.Last.ShippingService.Value := 'USPSPriority';
  eBayTrading1.AddItem.Request.Item.ShippingDetails.ShippingServiceOptions.Last.ShippingServiceCost.Value := 0;
  // return policy
  eBayTrading1.AddItem.Request.Item.ReturnPolicy.ReturnsAcceptedOption.Value := 'ReturnsNotAccepted';

  eBayTrading1.AddItem.Request.Item.DispatchTimeMax.Value := 2;
  eBayTrading1.Start;
end;

procedure TForm1.eBayTrading1Success(Sender: TeBayTrading);
var
  Url: string;
begin
  Url := 'http://cgi.sandbox.ebay.com/ws/eBayISAPI.dll?ViewItem&item=' +
    Sender.AddITem.Response.ItemID.Value;
  ShellExecute(self.WindowHandle,'open',PChar(URL),nil,nil, SW_SHOWNORMAL);
end;

procedure TForm1.eBayTrading1Error(Sender: TeBayTrading);
begin
  ShowMessage('Listing Error '+Sender.Error.EStr);
end;

end.
