unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTradingIntf, eBayTrading, eBayTradingAPI,
  EA4DAPI, xWSDLIntf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    eBayTrading1: TeBayTrading;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}
// If you own a webserver you may setup eBay Platform Notification
// Ebay will send to your webserver an alert (HTTP - XML SOAP) for
// each events you have registered for.
// see XMP API documentation : SetNotificationPreferences :
// SetNotificationPreferences is part of eBay Platform Notifications,
// an optional feature that alerts applications when certain
// events occur on the eBay site.
// This example shows how to initialize the corresponding component in delphi.
// We will use a "real life" notification (thank you rosedesir.com) that we load
// from a file

procedure TForm1.Button1Click(Sender: TObject);
var
  FS : TFileStream;
  Verb : string;
  FB : TeBayT_FeedBackDetailType;
begin
  Memo1.Clear;

  FS := TFileStream.Create('eBayNotif.txt', fmOpenRead or fmShareDenyWrite);
  try
    Verb:=eBayTrading1.InitFromeBayNotificationXML(FS);
  finally
    FS.Free;
  end;

  memo1.Lines.add('Function Name is : '+verb);
  // case sensitive
  if Verb='GetFeedback' then
  begin
    FB:=eBayTrading1.GetFeedback.Response.FeedbackDetailArray.FeedbackDetail[0];
    memo1.Lines.add('FeedBack received :');
    memo1.Lines.add('ItemID :'+FB.ItemID.Value);
    memo1.Lines.add('Your Role :'+FB.Role.Value);
    memo1.Lines.add('User :'+FB.CommentingUser.Value);
    memo1.Lines.add('Comment :'+FB.CommentText.Value);
  end;
end;

end.

