unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay,
  eBayFinding, eBayFindingIntf, eBayFindingAPI, xWSDLIntf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    eBaySession1: TeBaySession;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure eBayFindingError(Sender: TeBayFinding);
    procedure eBayFindingSuccess(Sender: TeBayFinding);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

Const
  ThreadCount = 4;

procedure TForm1.Button1Click(Sender: TObject);
var
  eBayFinding : TeBayFinding;
  i : integer;
begin
  // we create "ThreadCount" TeBayFinding at runtime
  for i:=1 to ThreadCount do
  begin
    eBayFinding := TeBayFinding.Create(Self);
    eBayFinding.Session := eBaySession1;
    if not(eBayFinding.isSessionValid) then
    begin
      showMessage('Invalid Session Parameters..');
      Halt;
    end;
    eBayFinding.findItemsByKeywords.Request.keywords.Value:='apple';
    eBayFinding.findItemsByKeywords.Request.paginationInput.pageNumber.Value:=i;
    eBayFinding.findItemsByKeywords.Request.paginationInput.entriesPerPage.Value:=10;
    eBayFinding.OnSuccess:=eBayFindingSuccess;
    eBayFinding.OnError:=eBayFindingError;
    eBayFinding.Start;
  end;
end;

procedure TForm1.eBayFindingSuccess(Sender: TeBayFinding);
var
  i, ItemCount : integer;
  Item :  TeBayF_SearchItem;
begin
  ItemCount:=Sender.findItemsByKeywords.Response.searchResult.item.Count;
  if ItemCount=0 then
  begin
    // Free TeBayFinding
    Sender.Free;
    exit;
  end;
  for i:=0 to ItemCount-1 do
  begin
    Item:=Sender.findItemsByKeywords.Response.searchResult.item[i];
    memo1.Lines.Add(Item.ItemID.Value+' : '+Item.Title.Value)
  end;
  i:=Sender.findItemsByKeywords.Request.paginationInput.pageNumber.Value;
  if (i=Sender.findItemsByKeywords.Response.paginationOutput.totalPages.Value) or (i>=100-ThreadCount) then
  begin
    // Free TeBayFinding
    Sender.Free;
    exit;
  end;
  // we have "ThreadCount" threads >> PageNumber + "ThreadCount"
  Sender.findItemsByKeywords.Request.paginationInput.pageNumber.Value := i + ThreadCount;
  Sender.Start;
end;

procedure TForm1.eBayFindingError(Sender: TeBayFinding);
begin
  case Sender.Error.EType of
    eBay.cEA4DError_EBAYError:
      begin
        ShowMessage('EBAY Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_HTTP:
      begin
        ShowMessage('HTTP Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_PARSING:
      begin
        ShowMessage('XML Parsing Error');
      end;
    eBay.cEA4DError_ABORT:
      begin
        ShowMessage('Abort');
      end;
  end;
  // Free TeBayFinding
  Sender.Free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Button1.Caption := Button1.Caption + ' ('+inttostr(ThreadCount)+' threads)';
  eBaySession1.loadFromINI('..\..\demosession.ini','SANDBOX');
  Memo1.Clear;
end;

end.

