unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTradingIntf, eBayTrading, eBayTradingAPI,
  EA4DAPI, xWSDLIntf, eBayFinding, eBayFindingIntf, eBayFindingAPI;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Button2: TButton;
    Button3: TButton;
    eBaySession1: TeBaySession;
    eBayTrading1: TeBayTrading;
    eBayTrading2: TeBayTrading;
    eBayFinding1: TeBayFinding;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure eBayTrading1Error(Sender: TeBayTrading);
    procedure eBayTrading1Success(Sender: TeBayTrading);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  eBayTrading1.GeteBayDetails.Request;
  eBayTrading1.Start;
end;

procedure TForm1.eBayTrading1Success(Sender: TeBayTrading);
begin
  // RequestType contains the last function name requested
  if Sender.RequestType='GeteBayOfficialTime' then
  begin
    button3.Caption:=datetimetostr(Sender.GeteBayOfficialTime.Response.Timestamp.AsLocalDateTime);
    exit;
  end;

  if Sender.RequestType='GeteBayDetails' then
  begin
    memo1.Text := Sender.XMLResponse();
    exit;
  end;

  ShowMessage('Unknown eBay Call : '+Sender.RequestType);

end;

procedure TForm1.eBayTrading1Error(Sender: TeBayTrading);
begin
  case Sender.Error.EType of
    eBay.cEA4DError_EBAYError:
      begin
        ShowMessage('EBAY Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_HTTP:
      begin
        ShowMessage('HTTP Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_PARSING:
      begin
        ShowMessage('XML Parsing Error');
      end;
    eBay.cEA4DError_ABORT:
      begin
        ShowMessage('Abort');
      end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  eBaySession1.loadFromINI('..\..\demosession.ini','SANDBOX');
  if not(eBayTrading1.isSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    Halt;
  end;
  Memo1.Clear;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if eBayTrading1.Busy then eBayTrading1.Abort;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if eBayTrading2.Busy then exit;
  eBayTrading2.GeteBayOfficialTime.Request;
  eBayTrading2.Start;
end;

end.

