unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayShoppingIntf, eBayShoppingAPI, eBayShopping,
  xWSDLIntf, eBayFinding, eBayFindingIntf, eBayFindingAPI;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    eBaySession1: TeBaySession;
    eBayShopping1: TeBayShopping;
    eBayFinding1: TeBayFinding;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure eBayFinding1Error(Sender: TeBayFinding);
    procedure eBayFinding1Success(Sender: TeBayFinding);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  if eBayFinding1.Busy then eBayFinding1.Abort;
  eBayFinding1.findItemsByKeywords.Request.keywords.Value:='apple';
  eBayFinding1.start;
end;

procedure TForm1.eBayFinding1Success(Sender: TeBayFinding);
var
  i, ItemCount : integer;
  // Items are returned in an array of TeBayF_SearchItem
  // use editor autocompletion feature to know...
  Item : TeBayF_SearchItem;
begin
  ItemCount:=Sender.findItemsByKeywords.Response.searchResult.item.Count;
  // If we dont have any item just exit;
  if ItemCount=0 then exit;

  // Show Item info
  for i:=0 to ItemCount-1 do
  begin
    Item:=Sender.findItemsByKeywords.Response.searchResult.item.Items[i];
    memo1.Lines.Add(Item.ItemID.Value+' : '+Item.Title.Value);
  end;
end;

procedure TForm1.eBayFinding1Error(Sender: TeBayFinding);
begin
  case Sender.Error.EType of
    eBay.cEA4DError_EBAYError:
      begin
        ShowMessage('EBAY Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_HTTP:
      begin
        ShowMessage('HTTP Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_PARSING:
      begin
        ShowMessage('XML Parsing Error');
      end;
    eBay.cEA4DError_ABORT:
      begin
        ShowMessage('Abort');
      end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  eBaySession1.loadFromINI('..\..\demosession.ini','SANDBOX');
  if not(eBayShopping1.isSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    Halt;
  end;
  Memo1.Clear;
end;

end.

