unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTradingIntf, eBayTrading;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    eBaySession1: TeBaySession;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    procedure eBayTradingError(Sender: TeBayTrading);
    procedure eBayTradingSuccess(Sender: TeBayTrading);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  eBayTrading : TeBayTrading;
begin
  // memos cleaning
  Memo1.Clear; Memo2.Clear; Memo3.Clear;

  // Create eBayTrading
  eBayTrading := TeBayTrading.Create(Self);
  // assign session
  eBayTrading.Session:=eBaySession1;
  // assign events
  eBayTrading.OnSuccess:=eBayTradingSuccess;
  eBayTrading.OnError:=eBayTradingError;

  eBayTrading.GeteBayOfficialTime.Request;

  if not(eBayTrading.isSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    Halt;
  end;

  eBayTrading.Start;
end;

procedure TForm1.eBayTradingSuccess(Sender: TeBayTrading);
var
  dt_local,dt_gmt : TDateTime;
begin
  dt_local:=Sender.GeteBayOfficialTime.Response.Timestamp.AsLocalDateTime;
  dt_gmt:=Sender.GeteBayOfficialTime.Response.Timestamp.AsGMTDateTime;
  memo1.Lines.Add('eBay time as local time is '+datetimetostr(dt_local)+' <<< check your PC clock :) ');
  memo1.Lines.Add('eBay time as GMT time is '+datetimetostr(dt_gmt));
  memo1.Lines.Add('Request duration '+inttostr(Sender.RequestDuration)+' ms');
  memo2.Lines.Add('XML Request');
  memo2.Lines.Add(Sender.XMLRequest);
  memo3.Lines.Add('XML Response');
  memo3.Lines.Add(Sender.XMLResponse);

  // You may destroy or start a TeBay... component in his own event
  Sender.Free
end;

procedure TForm1.eBayTradingError(Sender: TeBayTrading);
begin
  case Sender.Error.EType of
    eBay.cEA4DError_EBAYError:
      begin
        ShowMessage('EBAY Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_HTTP:
      begin
        ShowMessage('HTTP Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_PARSING:
      begin
        ShowMessage('XML Parsing Error');
      end;
    eBay.cEA4DError_ABORT:
      begin
        ShowMessage('Abort');
      end;
  end;

  // You may destroy or start a TeBay... component in his own event
  Sender.Free
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  eBaySession1.loadFromINI('..\..\demosession.ini','SANDBOX');
end;

end.
