unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTradingIntf, eBayTrading, eBayTradingAPI,
  EA4DAPI, xWSDLIntf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    eBaySession1: TeBaySession;
    eBayTrading1: TeBayTrading;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure eBayTrading1Error(Sender: TeBayTrading);
    procedure eBayTrading1Success(Sender: TeBayTrading);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  // We check if a request is pending
  if eBayTrading1.Busy then
  begin
    // Abort the request :
    eBayTrading1.Abort;
  end;
  Memo1.Clear; Memo2.Clear; Memo3.Clear;
  eBayTrading1.GeteBayOfficialTime.Request;
  eBayTrading1.Start;
end;

procedure TForm1.eBayTrading1Success(Sender: TeBayTrading);
var
  dt_local,dt_gmt : TDateTime;
begin
  dt_local:=Sender.GeteBayOfficialTime.Response.Timestamp.AsLocalDateTime;
  dt_gmt:=Sender.GeteBayOfficialTime.Response.Timestamp.AsGMTDateTime;
  memo1.Lines.Add('eBay time as local time is '+datetimetostr(dt_local)+' <<< check your PC clock :) ');
  memo1.Lines.Add('eBay time as GMT time is '+datetimetostr(dt_gmt));
  memo1.Lines.Add('Request duration '+inttostr(Sender.RequestDuration)+' ms');
  memo2.Lines.Add('XML Request');
  memo2.Lines.Add(Sender.XMLRequest);
  memo3.Lines.Add('XML Response');
  memo3.Lines.Add(Sender.XMLResponse);
end;

procedure TForm1.eBayTrading1Error(Sender: TeBayTrading);
begin
  case Sender.Error.EType of
    eBay.cEA4DError_EBAYError:
      begin
        ShowMessage('EBAY Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_HTTP:
      begin
        ShowMessage('HTTP Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_PARSING:
      begin
        ShowMessage('XML Parsing Error');
      end;
    eBay.cEA4DError_ABORT:
      begin
        ShowMessage('Abort');
      end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   // load session Parameters
  eBaySession1.loadFromINI('..\..\demosession.ini','SANDBOX');
  // eBaySession is assigned through the object inspector to eBayTrading1 (session property)
  // it can also be done at runtime :
  //   eBayTrading1.Session := eBaySession1;
  if not(eBayTrading1.isSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    Halt;
  end;
end;

end.
