unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTrading, eBayTradingIntf, eBayTradingAPI,
  EA4DAPI, xWSDLIntf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    eBayTrading1: TeBayTrading;
    procedure Button1Click(Sender: TObject);
    procedure eBayTrading1Error(Sender: TeBayTrading);
    procedure eBayTrading1Success(Sender: TeBayTrading);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  // eBayTrading1 may raise an exception if a request is pending
  // and the user clicks on button1
  // try it :)
  Memo1.Clear; Memo2.Clear; Memo3.Clear;
  eBayTrading1.Session.loadFromINI('..\..\demosession.ini','SANDBOX');
  if not(eBayTrading1.IsSessionValid) then
  begin
    showMessage('Invalid Session Parameters.');
    exit;
  end;
  eBayTrading1.GeteBayOfficialTime.Request;
  // Start request asynchronously
  eBayTrading1.Start;
end;

procedure TForm1.eBayTrading1Success(Sender: TeBayTrading);
var
  dt_local,dt_gmt : TDateTime;
begin
  // For Info : we are in the main thread (see EventMode property)
  dt_local:=Sender.GeteBayOfficialTime.Response.Timestamp.AsLocalDateTime;
  dt_gmt:=Sender.GeteBayOfficialTime.Response.Timestamp.AsGMTDateTime;
  memo1.Lines.Add('eBay time as local time is '+datetimetostr(dt_local)+' <<< check your PC clock :) ');
  memo1.Lines.Add('eBay time as GMT time is '+datetimetostr(dt_gmt));
  memo1.Lines.Add('Request duration '+inttostr(Sender.RequestDuration)+' ms');
  memo2.Lines.Add('XML Request');
  memo2.Lines.Add(Sender.XMLRequest);
  memo3.Lines.Add('XML Response');
  memo3.Lines.Add(Sender.XMLResponse);
end;

procedure TForm1.eBayTrading1Error(Sender: TeBayTrading);
begin
  // For Info : we are in the main thread (see EventMode property)
  case Sender.Error.EType of
    eBay.cEA4DError_EBAYError:
      begin
        ShowMessage('EBAY Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_HTTP:
      begin
        ShowMessage('HTTPS Error : '+(Sender.Error.ECode)+' - '+Sender.Error.EStr);
      end;
    eBay.cEA4DError_PARSING:
      begin
        ShowMessage('XML Parsing Error');
      end;
    eBay.cEA4DError_ABORT:
      begin
        ShowMessage('Abort');
      end;
  end;
end;

end.
