unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTradingIntf, eBayTrading, eBayTradingAPI,
  EA4DAPI, xWSDLIntf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Memo2: TMemo;
    Memo3: TMemo;
    eBayTrading1: TeBayTrading;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  R : Boolean;
  dt_local,dt_gmt : TDateTime;
begin
  // memos cleaning
  Memo1.Clear; Memo2.Clear; Memo3.Clear;
  eBayTrading1.Session.loadFromINI('..\..\demosession.ini','SANDBOX');
  if not(eBayTrading1.IsSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    exit;
  end;
  // Uncomment the line below to get an error response from eBay
  // eBayTrading1.Session.TradingToken:='';
  eBayTrading1.GeteBayOfficialTime.Request;
  R:=eBayTrading1.Call;
  if R then
  begin
    dt_local:=eBayTrading1.GeteBayOfficialTime.Response.Timestamp.AsLocalDateTime;
    // we get also the GMT date time
    dt_gmt:=eBayTrading1.GeteBayOfficialTime.Response.Timestamp.AsGMTDateTime;
    // show times :
    memo1.Lines.Add('eBay time as local time is '+datetimetostr(dt_local)+' <<< check your PC clock :) ');
    memo1.Lines.Add('eBay time as GMT time is '+datetimetostr(dt_gmt));
    // we show the request duration :
    memo1.Lines.Add('Request duration '+inttostr(eBayTrading1.RequestDuration)+' ms');
    // we show the XML sent to eBay :
    memo2.Lines.Add('XML Request');
    memo2.Lines.Add(eBayTrading1.XMLRequest);
    // we show the XML received from eBay :
    memo3.Lines.Add('XML Response');
    memo3.Lines.Add(eBayTrading1.XMLResponse);
  end else begin
    // We have an error, let's check which one it is
    case eBayTrading1.Error.EType of
    eBay.cEA4DError_EBAYError:
      begin
        // eBay has sent us an error..
        ShowMessage('EBAY Error : '+(eBayTrading1.Error.ECode)+' - '+eBayTrading1.Error.EStr);
      end;
    eBay.cEA4DError_HTTP:
      begin
        // Problem with internet...
        ShowMessage('HTTP Error : '+(eBayTrading1.Error.ECode)+' - '+eBayTrading1.Error.EStr);
      end;
    eBay.cEA4DError_PARSING:
      begin
        // The XML engine has crashed... send us an email...
        ShowMessage('XML Parsing Error');
      end;
    eBay.cEA4DError_ABORT:
      begin
        // The user has aborded the request ????
        // IMPOSSIBLE !! The call was synchronous !!!
      end;
    end;
  end;
end;

end.

