unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, eBay, eBayTrading, eBayTradingAPI, EA4DAPI, xWSDLIntf,
  eBayTradingIntf;

type
  TForm1 = class(TForm)
    Button1: TButton;
    eBayTrading1: TeBayTrading;
    eBaySession1: TeBaySession;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var
  R : Boolean;
  dt_local : TDateTime;
begin
  eBayTrading1.Session.loadFromINI('..\..\demosession.ini','SANDBOX');
  if not(eBayTrading1.IsSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    exit;
  end;
  // First, we need to load the session parameters :
  // We will use the Demo session file provided (eBay SandBox)
  // see tools/SessionEditor to create your own session file 
  // after registering to eBay developer program
  eBayTrading1.Session.loadFromINI('..\..\demosession.ini','SANDBOX');
  // Check if the session parameters seem valid for an eBay Trading call :
  if not(eBayTrading1.isSessionValid) then
  begin
    showMessage('Invalid Session Parameters..');
    exit;
  end;
  // We want to call the function "GeteBayOfficialTime"
  // By accessing GeteBayOfficialTime.Request or GeteBayOfficialTime.Response
  // eBayEx1 will automatically create the internal structures needed for
  // a GeteBayOfficialTime call :
  eBayTrading1.GeteBayOfficialTime.Request;
  // do the request synchronously :
  R:=eBayTrading1.Call;
  if R then
  begin
    // Request Success
    // get time translated to local date time
    dt_local:=eBayTrading1.GeteBayOfficialTime.Response.Timestamp.AsLocalDateTime;
    // show time;
    button1.caption:=datetimetostr(dt_local);
  end else begin
    // Request Error
    ShowMessage('ERROR !!!');
  end;
end;

end.
