unit Main;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls, StdActns,
  ActnList, ToolWin, ImgList, IniFiles, eBayTradingIntf, eBayTrading, eBay,
  eBayShoppingIntf, eBayShopping, eBayShoppingAPI, xWSDLIntf,
  eBayTradingAPI, EA4DAPI, eBayProduct, eBayProductIntf, eBayProductAPI,
  eBayFinding, eBayFindingIntf, eBayFindingAPI, eBayBestMatch,
  eBayBestMatchIntf, eBayBestMatchAPI, eBayMerchandising,
  eBayMerchandisingIntf, eBayMerchandisingAPI, eBayProductMeta,
  eBayProductMetaIntf, eBayProductMetaAPI;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    Edit1: TMenuItem;
    CutItem: TMenuItem;
    CopyItem: TMenuItem;
    PasteItem: TMenuItem;
    StatusBar: TStatusBar;
    ActionList1: TActionList;
    EditCut1: TEditCut;
    EditCopy1: TEditCopy;
    EditPaste1: TEditPaste;
    FileNew1: TAction;
    FileSave1: TAction;
    FileExit1: TAction;
    FileOpen1: TAction;
    FileSaveAs1: TAction;
    WindowCascade1: TWindowCascade;
    WindowTileHorizontal1: TWindowTileHorizontal;
    WindowArrangeAll1: TWindowArrange;
    WindowMinimizeAll1: TWindowMinimizeAll;
    HelpAbout1: TAction;
    WindowTileVertical1: TWindowTileVertical;
    ToolBar2: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton9: TToolButton;
    ImageList1: TImageList;
    Panel1: TPanel;
    Panel2: TPanel;
    lbSection: TListBox;
    Button1: TButton;
    Button2: TButton;
    Panel3: TPanel;
    PM1: TPopupMenu;
    UnitedStatesUS1: TMenuItem;
    USeBayMotors1: TMenuItem;
    MenuItem1: TMenuItem;
    Australia1: TMenuItem;
    AustriaAT1: TMenuItem;
    BelgiumDutchBENL1: TMenuItem;
    BelgiumFrench1: TMenuItem;
    CanadaCA1: TMenuItem;
    ChinaCN1: TMenuItem;
    FranceFR711: TMenuItem;
    GermanyDE771: TMenuItem;
    HongKongHK2011: TMenuItem;
    IrelandIE2051: TMenuItem;
    IndiaIN2031: TMenuItem;
    ItalyIT1011: TMenuItem;
    MalaysiaMY2071: TMenuItem;
    NetherlandsNL1461: TMenuItem;
    PhillipinesPH2111: TMenuItem;
    PolandPL2121: TMenuItem;
    SingaporeSG2161: TMenuItem;
    SpainES1861: TMenuItem;
    SwedenSE2181: TMenuItem;
    SwitzerlandCH1931: TMenuItem;
    aiwanTW1961: TMenuItem;
    UnitedKingdomUK31: TMenuItem;
    SaveDialog: TSaveDialog;
    Label1: TLabel;
    DevIdEdit: TEdit;
    Label11: TLabel;
    AppIdEdit: TEdit;
    Label3: TLabel;
    CertIdEdit: TEdit;
    TokenEdit: TMemo;
    SiteIdEdit: TEdit;
    Label12: TLabel;
    Button8: TButton;
    eBayShopping1: TeBayShopping;
    eBayTrading1: TeBayTrading;
    GroupBox1: TGroupBox;
    Button9: TButton;
    Button6: TButton;
    Label2: TLabel;
    GlobalIdEdit: TEdit;
    eBayTrading2: TeBayTrading;
    Label5: TLabel;
    Label7: TLabel;
    Button3: TButton;
    eBayFinding1: TeBayFinding;
    Button4: TButton;
    eBayProduct1: TeBayProduct;
    eBayBestMatch1: TeBayBestMatch;
    Button7: TButton;
    eBayMerchandising1: TeBayMerchandising;
    eBayProductMeta1: TeBayProductMeta;
    ScrollBox1: TScrollBox;
    Label4: TLabel;
    TradingUrlEdit: TEdit;
    Label21: TLabel;
    EPSUrlEdit: TEdit;
    ShoppingUrlEdit: TEdit;
    Label8: TLabel;
    FindingUrlEdit: TEdit;
    Label13: TLabel;
    ProductUrlEdit: TEdit;
    Label14: TLabel;
    ProductMetaUrlEdit: TEdit;
    Label15: TLabel;
    BestMatchUrlEdit: TEdit;
    Label9: TLabel;
    MerchandisingURLEdit: TEdit;
    Label10: TLabel;
    ClientAlertURLEdit: TEdit;
    Label16: TLabel;
    FeedbackURLEdit: TEdit;
    Label17: TLabel;
    BulkDataURLEdit: TEdit;
    Label18: TLabel;
    FileTransferURLEdit: TEdit;
    Label19: TLabel;
    ResoCaseMgtEdit: TEdit;
    Label20: TLabel;
    ReturnMgtEdit: TEdit;
    Label6: TLabel;
    BPMgtEdit: TEdit;
    Label22: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FileExit1Execute(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FileOpen1Execute(Sender: TObject);
    procedure lbSectionClick(Sender: TObject);
    procedure PM1Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure FileNew1Execute(Sender: TObject);
    procedure FileSaveAs1Execute(Sender: TObject);
    procedure FileSave1Execute(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure PM5Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure SavedChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure SiteIdEditClick(Sender: TObject);
  private
    { Private declarations }
    procedure AddSection(SectionName: string);
    procedure RefreshData(SectionName: string);
    procedure SaveData(SectionName: string);
    procedure UpdateSectionList;
  public
    { Public declarations }
    Mif : TMemIniFile;
    Save: Boolean;
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.RefreshData(SectionName: string);
begin
  Panel3.Caption := SectionName;
  DevIdEdit.Text := Mif.ReadString(SectionName, 'DevID', '');
  AppIdEdit.Text := Mif.ReadString(SectionName, 'AppID', '');
  CertIdEdit.Text := Mif.ReadString(SectionName, 'CertID', '');
  GlobalIdEdit.Text := Mif.ReadString(SectionName, 'GlobalID', '');
  SiteIdEdit.Text := IntToStr(Mif.ReadInteger(SectionName, 'SiteID', 0));
  TokenEdit.Text := Mif.ReadString(SectionName, 'Token', '');

  TradingUrlEdit.Text := Mif.ReadString(SectionName, 'TradingURL', '');
  EPSUrlEdit.Text := Mif.ReadString(SectionName, 'EPSURL', '');
  ShoppingUrlEdit.Text := Mif.ReadString(SectionName, 'ShoppingURL', '');
  FindingUrlEdit.Text := Mif.ReadString(SectionName, 'FindingURL', '');
  ProductUrlEdit.Text := Mif.ReadString(SectionName, 'ProductURL', '');
  ProductMetaUrlEdit.Text := Mif.ReadString(SectionName, 'ProductMetaURL', '');
  BestMatchUrlEdit.Text := Mif.ReadString(SectionName, 'BestMatchURL', '');
  MerchandisingURLEdit.Text := Mif.ReadString(SectionName, 'MerchandisingURL', '');
  ClientAlertURLEdit.Text := Mif.ReadString(SectionName, 'ClientAlertURL', '');
  FeedbackURLEdit.Text := Mif.ReadString(SectionName, 'FeedbackURL', '');
  BulkDataURLEdit.Text := Mif.ReadString(SectionName, 'BulkDataURL', '');
  FileTransferURLEdit.Text := Mif.ReadString(SectionName, 'FileTransferURL', '');
  ResoCaseMgtEdit.Text := Mif.ReadString(SectionName, 'ResoCaseMgtUrl', '');
  ReturnMgtEdit.Text := Mif.ReadString(SectionName, 'ReturnMgtUrl', '');
  BPMgtEdit.Text := Mif.ReadString(SectionName, 'BPMgtUrl', '');
end;

procedure TMainForm.SaveData(SectionName: string);
begin
  if SectionName = '' then
    Exit;

  Mif.WriteString(SectionName, 'DevID', DevIDEdit.Text);
  Mif.WriteString(SectionName, 'AppID', AppIDEdit.Text);
  Mif.WriteString(SectionName, 'CertID', CertIDEdit.Text);
  Mif.WriteInteger(SectionName, 'SiteID', StrToInt(SiteIDEdit.Text));
  Mif.WriteString(SectionName, 'GlobalID', GlobalIDEdit.Text);
  Mif.WriteString(SectionName, 'Token', TokenEdit.Text);
  Mif.WriteString(SectionName, 'TradingURL', TradingURLEdit.Text);
  Mif.WriteString(SectionName, 'EPSURL', EPSURLEdit.Text);
  Mif.WriteString(SectionName, 'ShoppingURL', ShoppingURLEdit.Text);
  Mif.WriteString(SectionName, 'FindingURL', FindingURLEdit.Text);
  Mif.WriteString(SectionName, 'ProductURL', ProductURLEdit.Text);
  Mif.WriteString(SectionName, 'ProductMetaURL', ProductMetaUrlEdit.Text);
  Mif.WriteString(SectionName, 'BestMatchURL', BestMatchURLEdit.Text);
  Mif.WriteString(SectionName, 'ClientAlertURL', ClientAlertURLEdit.Text);
  Mif.WriteString(SectionName, 'MerchandisingURL', MerchandisingURLEdit.Text);
  Mif.WriteString(SectionName, 'FeedbackURL', FeedbackURLEdit.Text);
  Mif.WriteString(SectionName, 'FileTransferURL', FileTransferURLEdit.Text);
  Mif.WriteString(SectionName, 'BulkDataURL', BulkDataURLEdit.Text);
  Mif.WriteString(SectionName, 'ResoCaseMgtUrl', ResoCaseMgtEdit.Text);
  Mif.WriteString(SectionName, 'ReturnMgtUrl', ReturnMgtEdit.Text);
  Mif.WriteString(SectionName, 'BPMgtUrl', BPMgtEdit.Text);
end;

procedure TMainForm.UpdateSectionList;
begin
  Mif.ReadSections(lbSection.Items);
end;

procedure TMainForm.AddSection(SectionName: string);
begin
  SectionName := Trim(SectionName);
  Mif.WriteString(SectionName,'SHOPPINGPLATFORM','');
  UpdateSectionList;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Mif := TMemIniFile.Create('');
  FileNew1Execute(Self);
  //ComboBox1.itemindex:=0;
  Save:=False;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Mif.Free;
end;

procedure TMainForm.FileExit1Execute(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.Button1Click(Sender: TObject);
var
  value: string;
begin
  SaveData(Panel3.caption);
  InputQuery('eBay Session File Editor', 'Please enter the Section name', value);
  value := trim(uppercase(value));
  if value = '' then
    Exit;
  if lbSection.Items.IndexOf(value) <> -1 then
    Exit;
  lbSection.ItemIndex := lbSection.Items.Add(value);
  RefreshData(value);
end;

procedure TMainForm.FileOpen1Execute(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    Mif.Free;
    Mif := TMemIniFile.Create(OpenDialog.FileName);
    UpdateSectionList;
    if lbSection.Items.Count > 0 then
    begin
      lbSection.itemIndex := 0;
      RefreshData(lbSection.Items[0]);
    end;
    FileSave1.Enabled := True;
    Save:=False;
  end;
end;

procedure TMainForm.lbSectionClick(Sender: TObject);
begin
 SaveData(Panel3.caption);
 if lbSection.itemIndex <> -1 then
 begin
   RefreshData(lbSection.Items[lbSection.itemIndex]);
 end;
end;

procedure TMainForm.PM1Click(Sender: TObject);
begin
  SiteIdEdit.Text := inttostr(TComponent(Sender).tag);
end;

procedure TMainForm.PM5Click(Sender: TObject);
begin
  SiteIdEdit.Text := inttostr(TComponent(Sender).tag);
end;

procedure TMainForm.Button6Click(Sender: TObject);
var
  DT: string;
begin
  if Panel3.caption = '' then
    Exit;
  SaveData(Panel3.caption);

  eBayTrading1.Session.loadFromINI(Mif, Panel3.caption);
  if Not(eBayTrading1.isSessionValid) then
  begin
    ShowMessage('Session data invalid !');
    Exit;
  end;
  eBayTrading1.GeteBayOfficialTime.Request;
  if Not(eBayTrading1.Call) then
  begin
    ShowMessage('eBay request error: '+ eBayTrading1.Error.EStr);
    Exit;
  end;
  DT := DateTimeToStr(eBayTrading1.GeteBayOfficialTime.Response.Timestamp.AsLocalDateTime);
  ShowMessage('GeteBayOfficialTime Success ! ('+DT+')');
  if Trim(eBayTrading1.Session.Token)<>'' then
  begin
    eBayTrading1.GetUser.Request;
    if Not(eBayTrading1.Call) then
    begin
      ShowMessage('eBay request error: '+ eBayTrading1.Error.EStr);
      Exit;
    end;
    ShowMessage('GetUser Success ! (UserId : '+eBayTrading1.GetUser.Response.User.UserID.Value+')');
  end;
end;

procedure TMainForm.Button9Click(Sender: TObject);
var
  DT: string;
begin
  ShowMessage('A RESfull session token is now required');
  Exit;
  if Panel3.caption = '' then
    Exit;
  SaveData(Panel3.caption);
  eBayShopping1.Session.loadFromINI(Mif, Panel3.caption);
  if Not(eBayShopping1.isSessionValid) then
  begin
    ShowMessage('Session data invalid !');
    Exit;
  end;
  eBayShopping1.GeteBayTime.Request;
  if Not(eBayShopping1.Call) then
  begin
    ShowMessage('eBay request error: '+ eBayShopping1.Error.EStr);
    Exit;
  end;
  DT := DateTimeToStr(eBayShopping1.GeteBayTime.Response.Timestamp.AsLocalDateTime);
  ShowMessage('Shopping - GeteBayTime Success ! ('+DT+')');

  eBayShopping1.GetUserProfile.Request.UserId.Value:='ea4ddemo01'; //yep my name :)
  if Not(eBayShopping1.Call) then
  begin
    ShowMessage('eBay request error: '+ eBayShopping1.Error.EStr);
    Exit;
  end;
  ShowMessage('Shopping - GetUser Success ! (UserId : '+eBayShopping1.GetUserProfile.Response.User.UserID.Value+')');
end;

procedure TMainForm.FileNew1Execute(Sender: TObject);
begin
  Mif.Free;
  Mif := TMemIniFile.Create('');
  AddSection('EBAYSESSION');
  lbSection.ItemIndex := 0;
  RefreshData('EBAYSESSION');
  FileSave1.Enabled := False;
  Save:=False;
end;

procedure TMainForm.FileSaveAs1Execute(Sender: TObject);
begin
  if SaveDialog.Execute then
  begin
    SaveData(Panel3.caption);
    Mif.Rename(SaveDialog.FileName, False);
    Mif.UpdateFile;
    FileSave1.Enabled := True;
    Save:=False;
  end;
end;

procedure TMainForm.FileSave1Execute(Sender: TObject);
begin
  SaveData(Panel3.caption);
  Mif.UpdateFile;
  Save:=False;
end;

procedure TMainForm.Button2Click(Sender: TObject);
begin
  if lbSection.ItemIndex <> -1 then
  begin
    lbSection.Items.Delete(lbSection.ItemIndex);
    if lbSection.Items.Count = 0 then
      FileNew1Execute(Self);
    lbSection.ItemIndex := 0;
  end;
end;

procedure TMainForm.SavedChange(Sender: TObject);
begin
  Save:=True;
end;

procedure TMainForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if Save then
  begin
    if MessageDlg('Save changes ?',mtConfirmation,[mbYes, mbNo],0) = mrYes then
      if FileSaveItem.enabled then
        FileSave1Execute(Self)
      else
        FileSaveAs1Execute(Self);
  end;
end;

procedure TMainForm.Button3Click(Sender: TObject);
begin
  if Panel3.caption = '' then
    Exit;
  SaveData(Panel3.caption);
  eBayFinding1.Session.loadFromINI(Mif, Panel3.caption);
  if Not(eBayFinding1.isSessionValid) then
  begin
    ShowMessage('Session data invalid !');
    Exit;
  end;
  eBayFinding1.findItemsByKeywords.Request.keywords.Value:='apple';
  if Not(eBayFinding1.Call) then
  begin
    ShowMessage('eBay request error: '+ eBayFinding1.Error.EStr);
    Exit;
  end;
  ShowMessage('Finding - findItemsByKeywords Success...');
end;

procedure TMainForm.Button4Click(Sender: TObject);
begin
  if Panel3.caption = '' then
    Exit;
  SaveData(Panel3.caption);
  eBayProduct1.Session.loadFromINI(Mif, Panel3.caption);
  if (eBayProduct1.Session.GlobalID<>'EBAY-MOTOR') then
  begin
    showmessage('Product service API requires EBAY MOTOR Production session parameters');
    exit;
  end;
  if Not(eBayProduct1.isSessionValid) then
  begin
    ShowMessage('Session data invalid !');
    Exit;
  end;
  eBayProduct1.getProductCompatibilities.Request.productIdentifier.ePID.Value:='76715700';
  eBayProduct1.getProductCompatibilities.Request.applicationPropertyFilter.New.propertyName.Value:='Make';
  eBayProduct1.getProductCompatibilities.Request.applicationPropertyFilter.Last.value.New.text.value.Value:='Honda';

  if Not(eBayProduct1.Call) then
  begin
    ShowMessage('eBay request error: '+ eBayProduct1.Error.EStr);
    Exit;
  end;
  ShowMessage('Product - getProductCompatibilities Success : '+#$D#$A+Copy(eBayProduct1.XMLResponse(), 1, 48)+'...');

  eBayProductMeta1.Session.loadFromINI(Mif, Panel3.caption);
  if Not(eBayProductMeta1.isSessionValid) then
  begin
    ShowMessage('Session data invalid !');
    Exit;
  end;
  eBayProductMeta1.getCompatibilitySearchNames.Request.categoryId.Value:='170577';
  if Not(eBayProductMeta1.Call) then
  begin
    ShowMessage('eBay request error: '+ eBayProductMeta1.Error.EStr);
    Exit;
  end;
  ShowMessage('Produc Meta - getCompatibilitySearchNames Success : '+#$D#$A+Copy(eBayProductMeta1.XMLResponse(), 1, 48)+'...');

end;

procedure TMainForm.Button7Click(Sender: TObject);
begin
  if Panel3.caption = '' then
    Exit;
  SaveData(Panel3.caption);
  eBayMerchandising1.Session.loadFromINI(Mif, Panel3.caption);
  if Not(eBayMerchandising1.isSessionValid) then
  begin
    ShowMessage('Session data invalid !');
    Exit;
  end;
  eBayMerchandising1.getDeals.Request.keywords.Value:='apple';
  if Not(eBayMerchandising1.Call) then
  begin
    ShowMessage('eBay request error: '+ eBayMerchandising1.Error.EStr);
    Exit;
  end;
  ShowMessage('Merchandising - getDeals Success : '+#$D#$A+Copy(eBayMerchandising1.XMLResponse(), 1, 48)+'...');
end;

procedure TMainForm.SiteIdEditClick(Sender: TObject);
var
  pnt: TPoint;
begin
  GetCursorPos(pnt);
  PM1.Popup(pnt.X, pnt.Y)
end;

end.

